<!DOCTYPE html>
<html lang="ru">
    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <meta http-equiv="X-UA-Compatible" content="ie=edge" />
        <meta property="og:type" content="article" />
        <meta property="og:title" content="Мийка13 – Професійна мийка вантажівок та спецтехніки" />
        <meta property="og:site_name" content="Moyka13" />
        <meta property="og:url" content="https://moyka13.com/" />
        <meta property="og:description" content="Мийка13 – якісна та швидка мийка вантажних автомобілів, фур, автобусів і спецтехніки. Сучасне обладнання, екологічні засоби та доступні ціни. Заїжджайте." />

        <meta property="og:image" content="https://auto.kim.kiev.ua/eva/images/og/auto_kim_1280x1280.jpg" />
        <meta property="og:image" content="https://auto.kim.kiev.ua/eva/images/og/auto_kim_mini.jpg" />
        <meta property="og:image" content="https://auto.kim.kiev.ua/eva/images/og/auto_kim_1280x1280.jpg" />

        <title>Мийка13 – Професійна мийка вантажівок та спецтехніки</title>

        <meta name="keywords" content="мойка грузовиков, мойка фур, автомойка для грузовиков, мойка спецтехники, грузовая мойка, Мойка13"/>
        <meta name="description" content="Мийка13 – якісна та швидка мийка вантажних автомобілів, фур, автобусів і спецтехніки. Сучасне обладнання, екологічні засоби та доступні ціни. Заїжджайте.">

        <link rel="canonical" href="https://moyka13.com">
        <link rel="icon" type="image/png" href="images/favicon.ico">

        <!-- magnific popup -->
        <link rel="preload stylesheet" type="text/css" href="css/magnific-popup.css" />

        <!-- Boxicon -->
        <link rel="preload stylesheet" type="text/css" href="css/boxicons.min.css" />

        <!-- preload woff2 -->
        <link rel="preload" href="fonts/boxicons.woff2" as="font" type="font/woff2" crossorigin>

        <!-- css -->

        <link href="css/bootstrap.min.css" rel="preload stylesheet" type="text/css" />
        <link href="css/style.css" id="app-css" rel="preload stylesheet" type="text/css" />

        <!-- Global Optimize -->
        <script src="https://www.googleoptimize.com/optimize.js?id=OPT-PFND3PZ"></script>

         
    </head>

    <body>
        
        <!-- Start КНОПКА СВЯЗИ -->
        <div class="dws">
            <a href="javascript:void(0)" data-toggle="modal" data-target="#messageModal">
                <div class="pulse">
                    <div class="phone"><i class="bx bx-phone" aria-hidden="true"></i></div>
                    <div class="text">Кнопка зв'язку</div>
                </div>
            </a>
        </div>
        <div class="modal fade" id="messageModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h6 class="modal-title">Вікно швидкого зв'язку</h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="send-form.php" method="POST" onsubmit="return validateInput3(this)" name="yo3" id="yo3">
                        <div class="modal-body text-center">
                            <h2 class="h4 mb-3">Є питання?</h2>
                            <div class="row">
                                <div class="col-12 mb-3 pb-3 border-bottom">
                                    <p>Залишіть свій номер телефону і ми зв'яжемося з Вами протягом 15 хвилин.</p>
                                    <div class="form-group">
                                        <input type="text" class="form-control" id="tel3" name="tel" placeholder="+380 ххх хх хх">
                                    </div>
                                    <a href="javascript:void(0)" onclick="savechanges3();" class="btn btn-sm btn-primary">Замовити дзвінок</a>
                                </div>
                                <div class="col-12 pt-3">
                                    <p>Графік роботи:</p>
                                    <p>ПН-ПТ: з 9:00 до 21:00</p>
                                    <p>СБ-НД: з 12:00 до 18:00</p>
<!--                                     <p>Или Вы можете позвонить нам самостоятельно нажав на кнопку</p>
                                    <div class="form-group">
                                        <a class="btn btn-sm btn-primary" href="tel:+380932637959">Позвонить</a>
                                    </div> -->
                                </div>
                            </div>
                            <div class="modal-footer mt-4">
                                <a href="javascript:void(0)" data-dismiss="modal" class="btn btn-sm btn-secondary">Закрити</a>
                            </div>
                        </div>
                        <input type="hidden" name="utm_source" value="<?php echo isset($_GET['utm_source']) ? $_GET['utm_source'] : '' ;?>">
                        <input type="hidden" name="utm_medium" value="<?php echo isset($_GET['utm_medium']) ? $_GET['utm_medium'] : '' ;?>">
                        <input type="hidden" name="utm_campaign" value="<?php echo isset($_GET['utm_campaign']) ? $_GET['utm_campaign'] : '' ;?>">
                        <input type="hidden" name="utm_content" value="<?php echo isset($_GET['utm_content']) ? $_GET['utm_content'] : '' ;?>">
                        <input type="hidden" name="utm_term" value="<?php echo isset($_GET['utm_term']) ? $_GET['utm_term'] : '' ;?>">
                    </form>
                </div>
            </div>
        </div>  
        <!-- end КНОПКА СВЯЗИ -->

        <!-- Start navbar -->
        <nav class="navbar navbar-expand-lg navbar-light fixed-top sticky">
            <div class="container">
                <a class="navbar-brand" href="https://moyka13.com">
                    <img src="images/m13_logo_red.png" class="logo-dark" alt="logo" height="50" />
                </a>
                <a href="#" class="navbar-toggler" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggle-icon"><i class="bx bx-menu"></i></span>
                </a>

                <div class="collapse navbar-collapse" id="navbarNav">
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item">
                            <a class="nav-link" href="#hello">Вітання</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#whyeva">Переваги</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#sravnite">Порівняйте</a>
                        </li>
                        <li class="nav-item">
                            <div class="dropdown">
                                <a class="nav-link" id="pokupatel" data-toggle="dropdown" href="#">Покупцеві<i class="bx bx-chevron-down align-middle font-size-18"></i></a>
                                <div class="dropdown-menu" aria-labelledby="pokupatel">
                                    <a class="dropdown-item" href="#video">Відео</a>
                                    <a class="dropdown-item" href="#portfolio">Фото робіт</a>
                                    <a class="dropdown-item" href="#review">Відгуки</a>
                                    <a class="dropdown-item" href="#voprosi">Відповіді на запитання</a>
                                </div>
                            </div>  
                        </li>
                        <li class="nav-item">
                            <div class="dropdown">
                                <a class="nav-link" id="dropShop" data-toggle="dropdown" href="#">Магазин<i class="bx bx-chevron-down align-middle font-size-18"></i></a>
                                <div class="dropdown-menu" aria-labelledby="dropShop">
                                    <a class="dropdown-item" href="#komplekti">Комплекти</a>
                                    <a class="dropdown-item" href="#aksesuari">Аксесуари</a>
                                    <a class="dropdown-item" href="#konstructor">Зібрати килимки</a>
                                </div>
                            </div>
                        </li>
                        <li class="nav-item">
                            <div class="dropdown">
                                <a class="nav-link" id="dropPhone" data-toggle="dropdown" href="#"><i class="bx bx-phone align-middle font-size-23 icon ml-1"></i><i class="bx bx-chevron-down align-middle font-size-18"></i></a>
                                <div class="dropdown-menu" aria-labelledby="dropPhone">
                                    <a class="dropdown-item" href="tel:+380932637959">093 263 79 59</a>
                                </div>
                            </div>  
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#contacts">Контакти</a>
                        </li>
                    </ul>
                    <a href="#order-form" class="btn btn-sm btn-outline-primary nav-btn ml-auto my-lg-0 my-2">Замовити</a>
                </div>
            </div>
        </nav>
        <!-- end navbar -->

        <!-- start Приветствие -->
        <section class="hero-3 position-relative" id="hello" style="background-image: url(images/hero-3-bg.jpg);">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="text-center hero-content">
                            <h1 class="font-weight-semibold hero-title my-4 pb-2">Мийка13 – вантажна автомийка нового рівня</h1>
                            <p class="text-uppercase badge badge-lg badge-soft-primary mb-4 pb-2"><b>Професійна мийка фур, вантажівок та спецтехніки</b></p><br>
                            <p class="font-weight-semibold pb-2">
                                <i class="bx bx-git-commit align-middle text-primary mr-2"></i>велика і зручна автомийка на лівому березі;<br>
                                <i class="bx bx-git-commit align-middle text-primary mr-2"></i>готівковий і безготівковий розрахунок (ПДВ);<br>
                                <i class="bx bx-git-commit align-middle text-primary mr-2"></i>внутрішня мийка та сан.обробка з документами.
                            </p>

                            <a href="#yur-osib" class="btn btn-outline-secondary mr-2 mb-2">Для юр. осіб</a>
                            <a href="#order-form" class="btn btn-primary mb-2">Замовити в 1 клік</a>
                            <!-- <img class="img-fluid mb-2 pb-2" src="images/evatop.jpg"> -->
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end Приветствие -->

        <!-- start преимущества -->
        <section class="section faq-bg" id="whyeva" style="background-image: url(images/hero-3-bg-2.jpg);">
            <div class="bg-overlay"></div>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5 col-md-6">
                        <h3 class="text-white mb-5">
                            Переваги
                        </h3>
                        <div class="accordion" id="accordionExample">
                            <div class="card rounded mb-3">
                                <div class="card-header position-relative border-bottom" id="headingOne">
                                    <a class="font-weight-medium faq-list mb-0" href="#collapseOne" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                        <i class="bx bx-wind align-middle text-primary font-size-24 mr-2 opacity-08"></i>Обслуговуємо великі авто
                                    </a>
                                </div>

                                <div id="collapseOne" class="collapse show" aria-labelledby="headingOne" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p class="text-muted mb-0">В нас великий бокс, в який без проблем заїдуть фури, атвобіси, тягачі, спец.техніка</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card rounded mb-3">
                                <div class="card-header border-bottom" id="headingTwo">
                                    <a class="font-weight-medium faq-list collapsed mb-0" href="#collapseTwo" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                        <i class="bx bx-donate-heart align-middle text-primary font-size-24 mr-2 opacity-08"></i>Прозорі ціни
                                    </a>
                                </div>
                                <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p class="text-muted mb-0">без прихованих платежів</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card rounded mb-3">
                                <div class="card-header border-bottom" id="headingThree">
                                    <a class="font-weight-medium faq-list collapsed mb-0" href="collapseThree" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                        <i class="bx bx-droplet align-middle text-primary font-size-24 mr-2 opacity-08"></i>Сучасне обладнання
                                    </a>
                                </div>
                                <div id="collapseThree" class="collapse" aria-labelledby="headingThree" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p class="text-muted mb-0">потужна техніка, безпечна хімія</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card rounded mb-3">
                                <div class="card-header border-bottom" id="headingFour">
                                    <a class="font-weight-medium faq-list collapsed mb-0" href="collapseFour" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                        <i class="bx bx-extension align-middle text-primary font-size-24 mr-2 opacity-08"></i>Швидке обслуговування
                                    </a>
                                </div>
                                <div id="collapseFour" class="collapse" aria-labelledby="headingFour" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p class="text-muted mb-0">без черг і затримок</p>
                                    </div>
                                </div>
                            </div>
                            <div class="card rounded mb-3">
                                <div class="card-header border-bottom" id="headingFive">
                                    <a class="font-weight-medium faq-list collapsed mb-0" href="collapseFive" data-toggle="collapse" data-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
                                        <i class="bx bx-volume-mute align-middle text-primary font-size-24 mr-2 opacity-08"></i>Екологічний підхід
                                    </a>
                                </div>
                                <div id="collapseFive" class="collapse" aria-labelledby="headingFive" data-parent="#accordionExample">
                                    <div class="card-body">
                                        <p class="text-muted mb-0">мінімальне використання води та безпечні мийні засоби</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="video" class="col-xl-5 col-lg-5 offset-lg-1 offset-xl-2 col-md-6">
                        <div class="card rounded text-center p-4">
                            <p class="text-muted mb-3"><b>ЕтиленВінілАцетат (севілен)</b> – дуже зносостійкий та досить жорсткий матеріал. Килимки EVA складаються з осередків глибиною 7 мм при загальній товщині виробу 10 мм. В результаті їм не потрібні борти для утримання води - вона рівномірно розподіляється по осередках, що неможливо у випадку з гумовими або текстильними килимками</p>
                        	<p class="text-primary text-uppercase">
                        		<b>
	                                <i class="bx bx-chevron-down font-size-18 text-primary"></i>
                            		Відео
	                                <i class="bx bx-chevron-down font-size-18 text-primary"></i>
                                </b>
                        	</p>
                            <div class="video-button">
                                <img class="img-fluid width-100 rounded" src="images/videoimg.jpg" alt="video" />
                                <a href="javascript:void(0)" data-toggle="modal" data-target="#videoModal" class="btn-video">
                                    <img class="img-fluid" src="images/play-icon.png" alt="" />
                                </a>
                            </div>
                            <div class="modal fade" id="videoModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h6 class="modal-title">2 Відео</h6>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <div class="mb-3 pb-2 border-bottom">
                                            	<span class="text-primary">
    				                                <!-- <i class="bx bx-chevron-down font-size-18"></i> -->
                                                	Відео килимків у салоні<br>
    				                                <!-- <i class="bx bx-chevron-down font-size-18"></i> -->
                                                </span>
                                                <iframe id="vid1" width="100%" height="250px" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                            <div>
                                            	<span class="text-primary">
    				                                <!-- <i class="bx bx-chevron-down font-size-18"></i> -->
                                                	Подивіться як легко килимки миються<br>
    				                                <!-- <i class="bx bx-chevron-down font-size-18"></i> -->
                                                </span>
                                                <iframe id="vid2" width="100%" height="250px" src="" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                            </div>
                                        </div>
                                        <div class="modal-footer mt-4">
                                            <a href="javascript:void(0)" data-dismiss="modal" class="btn btn-sm btn-secondary">Закрити</a>
                                        </div>
                                    </div>
                                </div>
                            </div>  
                            <a href="#order-form" class="btn btn-primary mt-4">Замовити</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end преимущества -->

        <!-- start service -->
        <section class="section bg-light" id="services">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <i class="bx bx-trending-up align-middle font-size-70 text-primary mb-3 pb-2"></i>
                                <h5 class="font-weight-medium font-size-18 mb-3">Шиємо з 2018 року</h5>
                                <p class="text-muted">За 3 роки ми відшили понад 20 000 комплектів килимів та зібрали свою базу лекал.</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <i class="bx bx-trophy align-middle font-size-70 text-primary mb-3 pb-2"></i>
                                <h5 class="font-weight-medium font-size-18 mb-3">Кращий матеріал</h5>
                                <p class="text-muted">У своєму виробництві ми використовуємо тільки якісний матеріал щільністю 60 ШОР, на відміну від бюджетних аналогів, наші килимки служать у 3-5 разів довше</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <i class="bx bx-lock align-middle font-size-70 text-primary mb-3 pb-2"></i>
                                <h5 class="font-weight-medium font-size-18 mb-3">Індивідуальний підхід</h5>
                                <p class="text-muted">При виготовленні килимків ми враховуємо всі Ваші побажання та особливості автомобіля</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <i class="bx bx-shield align-middle font-size-70 text-primary mb-3 pb-2"></i>
                                <h5 class="font-weight-medium font-size-18 mb-3">Розширена гарантія</h5>
                                <p class="text-muted">Повернення/обмін протягом 30 днів замість 14. Гарантія 12 місяців</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end services -->

        <!-- start Сравните сами -->
        <section class="section" id="sravnite">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Порівняйте самі</h3>
                            <p class="text-muted">Килимки EVA перевершують конкурентів за багатьма параметрами</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <div class="ribbon ribbon-muted">
                                    <span class="text-uppercase">Ворсові</span>
                                </div>
                                <img class="card-img-top img-fluid position-relative" src="images/vorsovie.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2">
                                <ul class="list-unstyled mb-2">
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Вода, бруд, сніг вбирається в килимок і промокає</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Замерзають і твердніють за мінусових температур</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Придатні лише для літньої експлуатації</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Вимагають регулярного догляду та хімчистки</li>
                                    <li class="text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Швидко протираються і рвуться особливо у місці підп'ятника</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <div class="ribbon ribbon-muted">
                                    <span class="text-uppercase">Гумові</span>
                                </div>
                                <img class="card-img-top img-fluid position-relative" src="images/rezinovie.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2">
                                <ul class="list-unstyled mb-2">
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-check align-middle text-primary icon font-size-18 mr-2"></i> Придатні для всесезонної експлуатації</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-check align-middle text-primary icon font-size-18 mr-2"></i> Відносно легко піддаються догляду</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Вода, бруд залишиться на килимі під ногами в кориті</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Замерзають та лопаються при мінусових температурах</li>
                                    <li class="text-muted font-size-16 py-2"><i class="bx bx-x align-middle text-muted icon font-size-18 mr-2"></i> Швидко протираються. Термін експлуатації до 12 місяців</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <div class="ribbon ribbon-primary">
                                    <span class="text-uppercase">EVA</span>
                                </div>
                                <img class="card-img-top img-fluid position-relative" src="images/evakovriki.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2">
                                <ul class="list-unstyled mb-0">
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-check-double align-middle text-primary icon font-size-18 mr-2"></i> Відмінно затримують бруд та вологу, захищаючи салон та взуття</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-check-double align-middle text-primary icon font-size-18 mr-2"></i> Чи не замерзають і не деформуються при зміні температури</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-check-double align-middle text-primary icon font-size-18 mr-2"></i> Ідеально підходять для всесезонної експлуатації</li>
                                    <li class="border-bottom text-muted font-size-16 py-2"><i class="bx bx-check-double align-middle text-primary icon font-size-18 mr-2"></i> Легко та швидко миються</li>
                                    <li class="text-muted font-size-16 py-2"><i class="bx bx-check-double align-middle text-primary icon font-size-18 mr-2"></i> Зносостійкий матеріал дозволяє експлуатувати килимки більше 36 місяців</li>
                                </ul>
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end Сравните сами -->
        
        <!-- start фото наших работ -->
        <section class="section bg-light" id="portfolio">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Фото наших робіт</h3>
                        </div>
                    </div>
                </div>
                <div id="carouselPortfolio" class="carousel slide" data-ride="carousel">
                    <ol class="carousel-indicators">
                        <li data-target="#carouselPortfolio" data-slide-to="0" class="active"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="1"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="2"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="3"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="4"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="5"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="6"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="7"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="8"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="9"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="10"></li>
                        <li data-target="#carouselPortfolio" data-slide-to="11"></li>
                    </ol>
                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio1.jpg" alt="First slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio2.jpg" alt="Second slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio3.jpg" alt="Third slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio7.jpg" alt="Fourth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio4.jpg" alt="Fifth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio5.jpg" alt="Sixth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio9.jpg" alt="Seventh slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio10.jpg" alt="Eighth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio12.jpg" alt="Ninth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio11.jpg" alt="Tenth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio8.jpg" alt="Eleventh slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/portfolio6.jpg" alt="Twelfth slide">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#carouselPortfolio" role="button" data-slide="prev">
                        <span aria-hidden="true"><i class="bx bx-chevron-left text-primary font-size-40 mr-2"></i></span>
                        <!-- <span class="sr-only">Previous</span> -->
                    </a>
                    <a class="carousel-control-next" href="#carouselPortfolio" role="button" data-slide="next">
                        <span aria-hidden="true"><i class="bx bx-chevron-right text-primary font-size-40 ml-2"></i></span>
                        <!-- <span class="sr-only">Next</span> -->
                    </a>
                </div>
            </div>
        </section>
        <!-- end фото наших работ -->

        <!-- our Магазин -->
        <section class="section shop" style="background-image: url(images/map-bg.jpg);" id="shop">
            <div class="container">
                <div class="row justify-content-center" id="komplekti">
                    <div class="col-lg-8">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Магазин</h3>
                            <p class="text-muted">Комплекти</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <img class="card-img-top img-fluid position-relative" src="images/price_econom.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2 m-1">
                                <p class="text-uppercase badge badge-soft-primary font-weight-100 font-size-18 mb-2 p-2">Комплект <b>Економ</b></p><br>
                                <span class="text-primary font-size-18"><em>1520 грн</em> <b>1290 грн</b></span><br>
                                <span class="text-muted font-size-14"> Економія 230 грн (-15%)</span>
                                <div class="card rounded mt-1 mb-0">
                                    <ul class="list-unstyled mb-0">
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 передніх килимка</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Перемичка на тунель</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 4 заводських кріплень</li>
                                        <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Система липучок до підлоги</li>
                                    </ul>
                                </div>
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <div class="ribbon ribbon-primary">
                                    <span class="text-uppercase">ТОП</span>
                                </div>
                                <img class="card-img-top img-fluid position-relative" src="images/price_standart.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2 m-1">
                                <p class="text-uppercase badge badge-soft-primary font-weight-100 font-size-18 mb-2 p-2">Комплект <b>Стандарт</b></p><br>
                                <span class="text-primary font-size-18"><em>2050 грн</em> <b>1740 грн</b></span><br>
                                <span class="text-muted font-size-14"> Економія 310 грн (-15%)</span>
                                <div class="card rounded mt-1 mb-0">
                                    <ul class="list-unstyled mb-0">
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 передні килимки</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 задніх килимка</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Перемичка на тунель</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 8 заводських кріплень</li>
                                        <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Система липучок до підлоги</li>
                                    </ul>
                                </div>
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <img class="card-img-top img-fluid position-relative" src="images/price_premium.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2 m-1">
                                <p class="text-uppercase badge badge-soft-primary font-weight-100 font-size-18 mb-2 p-2">Комплект <b>Преміум</b></p><br>
                                <span class="text-primary font-size-18"><em>3740 грн</em> <b>3180 грн</b></span><br>
                                <span class="text-muted font-size-14"> Економія 560 грн (-15%)</span>
                                <div class="card rounded mt-1 mb-0">
                                    <ul class="list-unstyled mb-0">
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 передніх килимка</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 задніх килимка</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Килимок в багажник</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Перемичка на тунель</li>
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 8 заводських кріплень</li>
                                        <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Система липучок до підлоги</li>
                                    </ul>
                                </div>
<!-- 		                        <div class="accordion" id="accordionPricePremium">
		                            <div class="card rounded mt-1 mb-0">
		                                <div class="" id="headingPricePremium">
		                                    <a class="btn btn-sm btn-outline-primary width-100" href="#collapsePricePremium" data-toggle="collapse" data-target="#collapsePricePremium" aria-expanded="true" aria-controls="collapsePricePremium">
		                                        Что входит<i class="bx bx-chevron-down align-middle text-primary font-size-16 mr-2"></i>
		                                    </a>
		                                </div>
		                                <div id="collapsePricePremium" class="collapse" aria-labelledby="headingPricePremium" data-parent="#accordionPricePremium">
		                                    <div class="card-body border-bottom border-left border-right py-1">
				                                <ul class="list-unstyled mb-0">
				                                    <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 передних коврика</li>
				                                    <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 2 задних коврика</li>
				                                    <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Коврик в багажник</li>
				                                    <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Перемычка на тунель</li>
				                                    <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 8 заводских креплений</li>
				                                    <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Система липучек к полу</li>
				                                </ul>
		                                    </div>
		                                </div>
		                            </div>
	                            </div> -->
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-center" id="aksesuari">
                    <div class="col-lg-8">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Магазин</h3>
                            <p class="text-muted">Аксесуари</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <div class="ribbon ribbon-primary">
                                    <span class="text-uppercase">ТОП</span>
                                </div>
                                <img class="card-img-top img-fluid position-relative" src="images/price_shildik.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2 m-1">
                                <p class="text-uppercase badge badge-soft-primary font-weight-100 font-size-18 mb-2 p-2"><b>Логотип</b> авто</p><br>
                                <span class="text-primary font-size-18"><em>205 грн</em> <b>145 грн</b></span><br>
                                <span class="text-primary"> Економія 60 грн (-30%)</span>
                                    <div class="card rounded mt-1 mb-0">
                                        <ul class="list-unstyled mb-0">
                                            <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Алюмінієвий шильдик</li>
                                            <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Надійно кріпиться болтиками</li>
                                        </ul>
                                    </div>
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <img class="card-img-top img-fluid position-relative" src="images/price_podpyatnik.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2 m-1">
                                <p class="text-uppercase badge badge-soft-primary font-weight-100 font-size-18 mb-2 p-2"><b>Підп'ятник</b></p><br>
                                <span class="text-primary font-size-18"><em>560 грн</em> <b>450 грн</b></span><br>
                                <span class="text-primary"> Економія 110 грн (-20%)</span>
                                <div class="card rounded mt-1 mb-0">
                                    <ul class="list-unstyled mb-0">
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Алюмінієвий прогумований</li>
                                        <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> Антиковзні вставки</li>
                                    </ul>
                                </div>
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card price-card active">
                            <div class="position-relative">
                                <div class="ribbon ribbon-primary">
                                    <span class="text-uppercase">ТОП</span>
                                </div>
                                <img class="card-img-top img-fluid position-relative" src="images/price_podpyatnik_eva.jpg" alt="" />
                            </div>
                            <div class="card-body px-4 py-2 m-1">
                                <p class="text-uppercase badge badge-soft-primary font-weight-100 font-size-18 mb-2 p-2"><b>Підп'ятник</b> EVA</p><br>
                                <span class="text-primary font-size-18"><em>310 грн</em> <b>250 грн</b></span><br>
                                <span class="text-primary"> Економія 60 грн (-20%)</span>
                                <div class="card rounded mt-1 mb-0">
                                    <ul class="list-unstyled mb-0">
                                        <li class="border-bottom text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 7 кольорів основи</li>
                                        <li class="text-muted py-2"><i class="bx bx-git-commit align-middle text-primary icon font-size-16 mr-2"></i> 9 кольорів окантовки</li>
                                    </ul>
                                </div>
                            </div>
                            <a href="#order-form" class="btn btn-primary mb-4 mx-4">Замовити</a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end Магазин -->

        <!-- start Отзывы -->
        <section class="section bg-light position-relative" id="review">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Відгуки</h3>
                            <p class="text-muted">Наші покупці радять нас друзям</p>
                        </div>
                    </div>
                </div>
                <div id="carouselReview" class="carousel slide" data-ride="carousel">
                    <ol class="carousel-indicators">
                        <li data-target="#carouselReview" data-slide-to="0" class="active"></li>
                        <li data-target="#carouselReview" data-slide-to="1"></li>
                        <li data-target="#carouselReview" data-slide-to="2"></li>
                        <li data-target="#carouselReview" data-slide-to="3"></li>
                        <li data-target="#carouselReview" data-slide-to="4"></li>
                        <li data-target="#carouselReview" data-slide-to="5"></li>
                        <li data-target="#carouselReview" data-slide-to="6"></li>
                        <li data-target="#carouselReview" data-slide-to="7"></li>
                        <li data-target="#carouselReview" data-slide-to="8"></li>
                    </ol>
                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="carousel-inner">
                                <div class="carousel-item active">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review8.jpg" alt="First slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review9.jpg" alt="Ninth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review7.jpg" alt="Second slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review2.jpg" alt="Third slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review6.jpg" alt="Fourth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review3.jpg" alt="Fifth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review1.jpg" alt="Sixth slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review5.jpg" alt="Seventh slide">
                                    </div>
                                </div>
                                <div class="carousel-item">
                                    <div class="mb-5">
                                        <img class="img-carousel rounded shadow-3" src="images/review4.jpg" alt="Eighth slide">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <a class="carousel-control-prev" href="#carouselReview" role="button" data-slide="prev">
                        <span aria-hidden="true"><i class="bx bx-chevron-left text-primary font-size-40 mr-2"></i></span>
                        <!-- <span class="sr-only">Previous</span> -->
                    </a>
                    <a class="carousel-control-next" href="#carouselReview" role="button" data-slide="next">
                        <span aria-hidden="true"><i class="bx bx-chevron-right text-primary font-size-40 ml-2"></i></span>
                        <!-- <span class="sr-only">Next</span> -->
                    </a>
                </div>
            </div>
        </section>
        <!-- end Отзывы -->

        <!-- start Конструктор Новый -->
        <section class="brand-section border-bottom" id="konstructor">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-5 col-md-6">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Зберіть свої килимки самі</h3>
                            <p class="text-muted">Скористайтеся зручним конструктором килимків auto.KIM та зберіть килимки своєї мрії за 7 простих кроків!</p>
                            <!-- <a href="#order-form" class="btn btn-primary mt-4">Собрать органайзер</a> -->
                            <a href="javascript:void(0)" data-toggle="modal" data-target="#konstruktorModal" class="btn btn-primary mt-4">Зібрати килимки</a>
                            <div class="modal fade" id="konstruktorModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h6 class="modal-title">Конструктор килимків Аuto.KIM</h6>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <div style="font-size: 0.7em; display: inline; margin-right: 12px;">
                                                    <span id='pgnm'>1</span>/7
                                                </div>
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <form action="send-form.php" method="POST" onsubmit="return validateInput2(this)" name="yo2" id="yo2">
                                            <ul class="nav nav-tabs" style="display: none;">
                                                <li class="nav-item">
                                                    <a id="swpg1" class="nav-link active" data-toggle="tab" href="#konstAuto">Авто</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a id="swpg2" class="nav-link" data-toggle="tab" href="#konstKomplekt">Комплект</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a id="swpg3" class="nav-link" data-toggle="tab" href="#konstCvetOsnovi">Колір основи</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a id="swpg4" class="nav-link" data-toggle="tab" href="#konstCvetKanta">Колір канта</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a id="swpg5" class="nav-link" data-toggle="tab" href="#konstLogotip">Логотип</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a id="swpg6" class="nav-link" data-toggle="tab" href="#konstPodpyatnik">Підп'ятник</a>
                                                </li>
                                                <li class="nav-item">
                                                    <a id="swpg7" class="nav-link" data-toggle="tab" href="#konstGotovo">Готово</a>
                                                </li>
                                            </ul>
                                            <div class="tab-content pt-3 pl-3 pr-3 pb-0">
                                                <div class="tab-pane fade show active" id="konstAuto">
                                                    <div class="modal-body">
                                                        <h2 class="h4 mb-3">Який у Вас автомобіль</h2>
                                                        <div class="row">
                                                            <div class="col-12 mb-3">
                                                                <p>Введіть марку, модель та рік Вашого авто</p>
                                                            </div>
                                                            <div class="col-12">
                                                                <div class="form-group">
                                                                    <!-- <label for="markauto">Марка авто:</label> -->
                                                                    <input type="text" class="form-control" id="auto2" name="auto" placeholder="BMW X7 2021г">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer mt-4">
                                                            <a href="javascript:void(0)" data-dismiss="modal" class="btn btn-sm btn-secondary">Закрити</a>
                                                            <a href="javascript:void(0)" onclick="SwitchTab(2);" class="btn btn-sm btn-primary">Далі</a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="konstKomplekt">
                                                    <h2 class="h4 mb-3">Комплект</h2>
                                                    <div class="row">
                                                        <div class="col-12 mb-3">
                                                            <p>Виберіть комплект</p>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_econom.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>1130 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="komplekt1" name="komplekt" value="Эконом" class="custom-control-input" checked="checked">
                                                                <label class="custom-control-label" for="komplekt1">Передні килимки</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_standart.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>1540 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="komplekt2" name="komplekt" value="Стандарт" class="custom-control-input">
                                                                <label class="custom-control-label" for="komplekt2">Передні + задні</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_premium.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>2690 грн</b></span>
                                                            <!-- <p>Коричневый</p> -->
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="komplekt3" name="komplekt" value="Премиум" class="custom-control-input">
                                                                <label class="custom-control-label" for="komplekt3">Передні + задні + багажник</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer mt-4">
                                                        <a href="javascript:void(0)" onclick="SwitchTab(1);" class="btn btn-sm btn-secondary">Назад</a>
                                                        <a href="javascript:void(0)" onclick="SwitchTab(3);" class="btn btn-sm btn-primary">Далі</a>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="konstCvetOsnovi">
                                                    <h2 class="h4 mb-3">Колір основи</h2>
                                                    <div class="row">
                                                        <div class="col-12 mb-3">
                                                            <p>Виберіть колір основи килимків</p>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_black.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi1" name="cvetOsnovi" value="Чорний" class="custom-control-input" checked="checked">
                                                                <label class="custom-control-label" for="cvetOsnovi1">Чорний</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_gray.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi2" name="cvetOsnovi" value="Сірий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetOsnovi2">Сірий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_beige.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi3" name="cvetOsnovi" value="Бежевий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetOsnovi3">Бежевий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_brown.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi4" name="cvetOsnovi" value="Коричневий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetOsnovi4">Корич-<br>невий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_blue.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi5" name="cvetOsnovi" value="Синій" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetOsnovi5">Синій</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_red.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi7" name="cvetOsnovi" value="Червоний" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetOsnovi7">Червоний</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/osnova2/mat_white.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetOsnovi6" name="cvetOsnovi" value="Білий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetOsnovi6">Білий</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer mt-4">
                                                        <a href="javascript:void(0)" onclick="SwitchTab(2);" class="btn btn-sm btn-secondary">Назад</a>
                                                        <a href="javascript:void(0)" onclick="SwitchTab(4);" class="btn btn-sm btn-primary">Далі</a>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="konstCvetKanta">
                                                    <h2 class="h4 mb-3">Колір окантовки</h2>
                                                    <div class="row">
                                                        <div class="col-12 mb-3">
                                                            <p>Виберіть колір окантовки килимків</p>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_black.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta1" name="cvetKanta" value="Чорний" class="custom-control-input" checked="checked">
                                                                <label class="custom-control-label" for="cvetKanta1">Чорний</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_gray.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta2" name="cvetKanta" value="Сірий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta2">Сірий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_beige.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta3" name="cvetKanta" value="Бежевий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta3">Бежевий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_brown.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta4" name="cvetKanta" value="Коричневий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta4">Корич-<br>невий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_blue.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta5" name="cvetKanta" value="Синій" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta5">Синій</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_red.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta6" name="cvetKanta" value="Червоний" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta6">Червоний</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_white.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta7" name="cvetKanta" value="Білий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta7">Білий</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-3 col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/kant2/kant_yellow.jpg">
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="cvetKanta8" name="cvetKanta" value="Жовтий" class="custom-control-input">
                                                                <label class="custom-control-label" for="cvetKanta8">Жовтий</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer mt-4">
                                                        <a href="javascript:void(0)" onclick="SwitchTab(3);" class="btn btn-sm btn-secondary">Назад</a>
                                                        <a href="javascript:void(0)" onclick="SwitchTab(5);" class="btn btn-sm btn-primary">Далі</a>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="konstLogotip">
                                                    <h2 class="h4 mb-3">Логотип</h2>
                                                    <div class="row">
                                                        <div class="col-12 mb-3">
                                                            <p>Виберіть потрібну кількість логотипів</p>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_0logo.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>+0 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="kolLogo1" name="kolLogo" value="Без логотипів" class="custom-control-input" checked="checked">
                                                                <label class="custom-control-label" for="kolLogo1">Без логотипів</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_2logo.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>+290 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="kolLogo2" name="kolLogo" value="2 логотипа" class="custom-control-input">
                                                                <label class="custom-control-label" for="kolLogo2">2 логотипа</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_4logo.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>+500 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="kolLogo3" name="kolLogo" value="4 логотипа" class="custom-control-input">
                                                                <label class="custom-control-label" for="kolLogo3">4 логотипа</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer mt-4">
                                                        <a href="javascript:void(0)" onclick="SwitchTab(4);" class="btn btn-sm btn-secondary">Назад</a>
                                                        <a href="javascript:void(0)" onclick="SwitchTab(6);" class="btn btn-sm btn-primary">Далі</a>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="konstPodpyatnik">
                                                    <h2 class="h4 mb-3">Підп'ятник</h2>
                                                    <div class="row">
                                                        <div class="col-12 mb-3">
                                                            <p>Виберіть підп'ятник</p>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/konstructor/konst_podp_netu.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>+0 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="podpyatnik1" name="podpyatnik" value="Без підп'ятника" class="custom-control-input" checked="checked">
                                                                <label class="custom-control-label" for="podpyatnik1">Без підп'ятника</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/price_podpyatnik.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>+400 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="podpyatnik2" name="podpyatnik" value="Підп'ятник алюміній" class="custom-control-input">
                                                                <label class="custom-control-label" for="podpyatnik2">Підп'ятник алюміній</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-4">
                                                            <img class="brd-modal modal-img" src="images/price_podpyatnik_eva.jpg">
                                                            <span class="text-uppercase badge badge-soft-primary font-weight-100 font-size-16 mt-1"><b>+250 грн</b></span>
                                                            <div class="custom-control custom-radio">
                                                                <input type="radio" id="podpyatnik3" name="podpyatnik" value="Підп'ятник EVA" class="custom-control-input">
                                                                <label class="custom-control-label" for="podpyatnik3">Підп'ятник EVA</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer mt-4">
                                                        <a href="javascript:void(0)" onclick="SwitchTab(5);" class="btn btn-sm btn-secondary">Назад</a>
                                                        <a href="javascript:void(0)" onclick="SwitchTab(7);" class="btn btn-sm btn-primary">Далі</a>
                                                    </div>
                                                </div>
                                                <div class="tab-pane fade" id="konstGotovo">
                                                    <h2 class="h4 mb-3">Готово</h2>
                                                    <div class="form-group">
                                                        <label for="marka">Ваше ім'я</label>
                                                        <input type="text" class="form-control" id="fio2" name="fio" aria-describedby="emailHelp" placeholder="Введіть ваше ім'я">
                                                    </div>
                                                    <div class="form-group">
                                                        <label for="tel2">Ваш телефон</label>
                                                        <input type="text" class="form-control" id="tel2" name="tel" placeholder="+380xxxxxxxxx">
                                                    </div>
                                                    <div class="modal-footer mt-4">
                                                        <a href="javascript:void(0)" onclick="SwitchTab(6);" class="btn btn-sm btn-secondary">Назад</a>
                                                        <a href="javascript:void(0)" onclick="savechanges2();" class="btn btn-sm btn-primary">Готово</a>
                                                    </div>
                                                </div>
                                                <input type="hidden" name="utm_source" value="<?php echo isset($_GET['utm_source']) ? $_GET['utm_source'] : '' ;?>">
                                                <input type="hidden" name="utm_medium" value="<?php echo isset($_GET['utm_medium']) ? $_GET['utm_medium'] : '' ;?>">
                                                <input type="hidden" name="utm_campaign" value="<?php echo isset($_GET['utm_campaign']) ? $_GET['utm_campaign'] : '' ;?>">
                                                <input type="hidden" name="utm_content" value="<?php echo isset($_GET['utm_content']) ? $_GET['utm_content'] : '' ;?>">
                                                <input type="hidden" name="utm_term" value="<?php echo isset($_GET['utm_term']) ? $_GET['utm_term'] : '' ;?>">
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>                            
                        </div>
                    </div>
                    <div class="col-xl-5 col-lg-5 offset-lg-1 offset-xl-2 col-md-6">
                        <div class="card text-center active mb-4 shadow-2">
                            <div class="card-body px-4 position-relative">
                                <img class="card-img-top img-fluid position-relative" src="images/konstruktorimg.jpg" alt="konstruktorimg" />
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end Конструктор Новый -->


        <!-- start ФОРМА ЗАКАЗА -->
        <section class="section" id="order-form">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-body">
                                <div class="text-center">
                                    <h3 class="mb-0">Форма замовлення</h3>
                                    <div class="title-line mx-auto my-4"></div>
                                    <p class="text-uppercase font-size-14 font-weight-semibold mb-0">Заповніть форму і ми зв'яжемося з Вами протягом 15 хвилин.<br /> Наші менеджери із задоволенням проконсультують Вас з будь-якого питання</p>
                                </div>
                                <form class="mt-5" action="send-form.php" method="POST" onsubmit="return validateInput(this)" name="yo" id="yo">
                                    <p id="error-msg"></p>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input id="fio" name="fio" type="text" class="form-control bg-transparent" placeholder="Ваше ПІБ" />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input id="tel" name="tel" type="email" class="form-control bg-transparent" placeholder="+380 ххх хх хх"  />
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <input id="auto" name="auto" type="text" class="form-control bg-transparent" placeholder="Марка авто"  />
                                            </div>
                                        </div>
                                        <div class="col-md-12 text-center">
                                            <div class="form-group">
                                                <a class="btn btn-primary mt-3" href="javascript:void(0)" onclick="savechanges();">Замовити килимки</a>
                                            </div>
                                        </div>                                        
                                        <input type="hidden" name="utm_source" value="<?php echo isset($_GET['utm_source']) ? $_GET['utm_source'] : '' ;?>">
                                        <input type="hidden" name="utm_medium" value="<?php echo isset($_GET['utm_medium']) ? $_GET['utm_medium'] : '' ;?>">
                                        <input type="hidden" name="utm_campaign" value="<?php echo isset($_GET['utm_campaign']) ? $_GET['utm_campaign'] : '' ;?>">
                                        <input type="hidden" name="utm_content" value="<?php echo isset($_GET['utm_content']) ? $_GET['utm_content'] : '' ;?>">
                                        <input type="hidden" name="utm_term" value="<?php echo isset($_GET['utm_term']) ? $_GET['utm_term'] : '' ;?>">
                                    </div>
                                </form>
                            </div>
                        </div>   
                    </div>
                </div>
            </div>
        </section>
        <!-- end ФОРМА ЗАКАЗА -->

        <!-- start ОТВЕТЫ НА ВОПРОСЫ -->
        <section class="section bg-light border-bottom" id="voprosi">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <div class="text-center mb-5">
                            <h3 class="font-weight-medium mb-3">Часто задавані питання</h3>
                            <p class="text-muted">Відповіді на найпопулярніші запитання</p>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Як відрізнити оригінальні EVA від підробки</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> На жаль візуально і на дотик відрізнити неможливо адже різниця тільки в щільності (у нас 60шор, у дешевих аналогів 30шор). Відрізнити можна лише через півроку експлуатації, найчастіше дешеві аналоги виявляються після мінусових температур. Завжди купуйте у перевірених виробників, наші килимки EVA служать покупцям 3-5 років. Намагаючись заощадити 200-300 гривень, покупці дешевих аналогів викидають килимки через одну зиму.</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> З якого матеріалу виготовлені килимки</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Для виготовлення килимків ми використовуємо інноваційний матеріал з унікальною комірчастою структурою - ЕтиленВінілАцетат (Ethylene Vinyl Acetate - EVA або Севілен). Він дуже зносостійкий, міцний, функціональний та стильний, зручний та при цьому дуже легкий і має властивість самовідновлення. Серед переваг цього матеріалу: здатність утримувати велику кількість рідини, стійкість до хімічних реагентів, відсутність запахів, асболютна безпека для здоров'я навколишнього середовища, Вашого здоров'я, Ваших дітей і навіть тварин, збереження всіх своїх властивостей при жарі +50° та при морозі -55°</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Чи є у килимків гарантія</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Так, гаратія на всю продукцію 12 місяців. Термін служби багато в чому залежить від експлуатації, і навіть при сильному зносі, наприклад взуття з гострими шпильками, килимки прослужать Вам багато років</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Килимки EVA відрізняються від оригінальних по формі</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Наші вироби можуть відрізнятись від оригінальних. Але це не є недоліком, навіть навпаки. Ми викроюємо наші килимки за власними лекалами так, щоб виріб покривав максимальну площу підлоги по кузову, у зв'язку з цим килимки EVA відрізнятимуться за формою від рідних</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Як доглядати за килимками</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Незважаючи на те що килимки легко вимиваються, вони так само розраховані на мийку під сильним натиском води, весь бруд, що скупчився в осередках моментально вимивається. EVA не боїться миючих засобів та автошампунів. Наші килимки можна мити щоразу, коли Ви заїжджаєте на мийку</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Які килимки краще підійдуть для зими/осені</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Всі вироби EVA чудово підійдуть для дощових та снігових сезонів. Вони не задубіють від морозів, аж до -55° (на відміну від гумових), і не розм'якнуть від води, як ворсові</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Скільки служать килимки</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Термін служби килимків EVA не поступається ворсовим і навіть гумовим аналогам. При дбайливому користуванні килимки можуть прослужити до 10 років, середній термін служби наших килимків 3-5 років</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i>  Чи бояться килимки гострих шпильок</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Килимки EVA дуже зносостійкі. Однак через відносну еластичність і м'якість, які дарують комфорт під ногами, килимки можна пошкодити, незважаючи на ці пошкодження килимки не промокатимуть і попускатимуть вологу.</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Чи є запах у килимків</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Килимки можуть мати, як і будь-які вироби, тільки якщо вони нові. Запах швидко зникає і знову не з'являється. Матеріал EVA (севілен) екологічно чистий та гіпоалергенний виготовляється з екологічно чистих компонентів і в подальшій експлуатації не пахне навіть при сильно підвищених температурах (+50°)</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Чи не псують килимки взуття</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Килимки EVA не тільки не псують взуття, навпаки, допомагають зберегти його чистим. Поверхня виробів має комірчасту структуру глибиною 7мм при товщині матеріалу 10мм, в ці осередки провалюється весь бруд і волога. Крім того, автокилимки не стираються про підошву взуття. Сам матеріал EVA навіть використовується у виробництві спортивного взуття</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Як килимки кріпляться до кузова</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Килимки переважно кріпляться системою липучок. Але для моделей авто, які обладнані заводськими кріпленнями, ми встановлюємо фурнітуру у відповідь для максимальної фіксації. Також килимки максимально точно повторюють форму кузова завдяки чому ковзання килимків по салону виключено.</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Як правильно укладати килимки</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> При цифровому знятті лекал ми максимально закриваємо підлогу салону, тому наші килимки в багатьох випадках більше гумових або оригінальних, у зв'язку з цим може здатися, що килимки великі, але постеливши килимки в салон на свої місця. Ви побачите точний збіг з формою кузова.</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Чи можна зробити 3D з бортами</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Це питання задається дуже часто, 3D борти не прилягають максимально до кузова через неідеально рівну форму у зв'язку з чим з часом вони починають відгинатися і експлуатувати килимок стає неможливим. Незважаючи на пряму форму килимків волога і бруд не скочуватиметься в кузов завдяки своїй пористій структурі</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="card text-center active mb-4">
                            <div class="card-body px-4 pt-4">
                                <h5 class="font-weight-medium font-size-18 mb-3"><i class="bx bx-help-circle font-size-20"></i> Який колір найпрактичніший</h5>
                                <p class="text-muted mb-2"><i class="bx bx-undo align-middle bx-rotate-180 font-size-20"></i> Найпрактичніші кольори для килимків - сірий та бежевий. Найпопулярніше поєднання кольорів це сіра основа із чорним кантом. Сірі ідеально підходять під темні салони, бежевий – для світлих. Якщо порівнювати по забрудненням, то на бежеві більш практичні в суху погоду, пил і пісок за своєю природою мають світло-бежевий відтінок візуально зливається з бежевим кольором. А в сиру погоду, навпаки, практичнішими будуть сірі, оскільки на них менше помітний мокрий бруд.</p>
                                <a href="#order-form">Замовити в 1 клік<i class="bx bx-right-arrow-alt align-middle font-size-18 icon ml-1"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- end ОТВЕТЫ НА ВОПРОСЫ -->

        <!-- start footer -->
        <footer class="footer bg-light" id="contacts">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-md-3 mt-sm-0 mt-5">
                        <a href="#" class="footer-logo">
                            <img src="images/logo_auto_black.png" class="logo-dark" alt="" height="50" />
                        </a>
                        <p class="text-muted mt-4 pt-2">Автокилимки та аксесуари преміум якості<br><br><br><br>від виробника №1 в Україні</span></p>
                        <a href="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d635.2860971218674!2d30.62233172920176!3d50.43841115287661!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0x0!2zNTDCsDI2JzE4LjMiTiAzMMKwMzcnMjIuNCJF!5e0!3m2!1sru!2sua!4v1616597903213!5m2!1sru!2sua" class="google-map btn btn-white mt-3 map-hover">
                            <i class="bx bx-map-pin icon font-size-18 align-middle mr-1"></i>Подивитись на мапі
                        </a>
                    </div>
                    <div class="col lg-1"></div>
                    <div class="col-lg-2 col-md-3 mt-sm-0 mt-5">
                        <h4 class="font-size-18 mb-0">Мапа сайту</h4>
                        <ul class="list-unstyled mt-4 mb-0">
                            <li class="py-1">
                                <a href="#hello">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Вітання
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#whyeva">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Переваги
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#sravnite">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Порівняння
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#portfolio">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Фото рабіт
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#shop">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Магазин
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="#order-form">
                                    <i class="bx bx-git-commit align-middle text-primary icon font-size-18 mr-2"></i>
                                    Замовити
                                </a>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-md-3 mt-sm-0 mt-5">
                        <h4 class="font-size-18 mb-0">Графік роботи</h4>
                        <ul class="list-unstyled mt-4 mb-0">
                            <li class="py-1">
                                <span class="text-muted"><i class="bx bx-time align-middle text-primary icon font-size-18 mr-2"></i> Пн-Пт: з 9:00 до 21:00</span>
                            </li>
                            <li class="py-1">
                                <span class="text-muted"><i class="bx bx-time align-middle text-primary icon font-size-18 mr-2"></i> Сб-Нд: з 12:00 до 18:00</span>
                            </li>
                        </ul>
                    </div>
                    <div class="col-lg-3 col-md-3 mt-sm-0 mt-5">
                        <h4 class="font-size-18 mb-0">Контакти</h4>
                        <ul class="list-unstyled mt-4 mb-0">
                            <li class="py-1">
                                <a href="tel:+380932637959"><i class="bx bx-phone align-middle text-primary icon font-size-18 mr-2"></i> 093 263 79 59</a>
                            </li>
                            <li class="py-1">
                                <span class="text-muted"><i class="bx bx-map align-middle text-primary icon font-size-18 mr-2"></i> м.Київ, вул.Регенераторна, 4</span>
                                <!-- <a href="#"><i class="bx bx-map align-middle text-primary icon font-size-18 mr-2"></i> г.Киев, ул.Регенераторная, 4</a> -->
                            </li>
                            <li class="py-1">
                                <a href="mailto:dir@auto.kim.kiev.ua">
                                    <i class="bx bx-mail-send align-middle text-primary icon font-size-18 mr-2"></i>
                                    dir@auto.kim.kiev.ua
                                </a>
                            </li>
                            <li class="py-1">
                                <a href="https://auto.kim.kiev.ua">
                                    <i class="bx bx-world align-middle text-primary icon font-size-18 mr-2"></i>
                                    auto.kim.kiev.ua
                                </a>
                            </li>
                            <li class="py-1 mt-1">
                                <a href="https://www.instagram.com/auto.kim.kiev.ua/">
                                    <img src="images/inst1new.png" alt="instagram" class="rounded">
                                    <img src="images/inst0new.png" alt="instagram" class="rounded img-hover-inst">
                                </a>
                                <a href="https://facebook.com/auto.kim.kiev.ua/" class="ml-2">
                                    <img src="images/fb1new.png" alt="facebook" class="rounded">
                                    <img src="images/fb0new.png" alt="facebook" class="rounded img-hover-fb">
                                </a>
                            </li>
                            <li>
                                <br>
                                <i class="bx bx-list-check align-middle text-primary icon font-size-18 mr-2"></i>
                                <a href="terms.php">Умови угоди</a>
                            </li>
                            <li>
                                <i class="bx bx-shield align-middle text-primary icon font-size-18 mr-2"></i>
                                <a href="privacy.php">Політика безпеки</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>
        <!-- end footer -->

        <!-- start footer alter -->
        <div class="footer-alt bg-primary">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="py-4">
                            <p class="text-white text-center mb-0">2021 © auto.kim. Design By Kim</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- end footer alter -->

        <script src="js/jquery-3.5.1.min.js"></script>
        <script src="js/bootstrap.bundle.min.js"></script>

        <!-- smooth link -->
        <script src="js/scrollspy.min.js"></script>
        <script src="js/jquery.easing.min.js"></script>

        <!-- magnific popup -->
        <script src="js/jquery.magnific-popup.min.js"></script>
        <script src="js/magnific.init.js"></script>

        <script src="js/app.js"></script>
    </body>
</html>
